package some;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.LabeledCell;
import net.w_horse.excelpojo.annotation.MappedCell;
import net.w_horse.excelpojo.annotation.PointedCell;
import net.w_horse.excelpojo.annotation.VerticalRepeats;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;


@Bean
public class UserList2 {
	@LabeledCell(label = "^Cg", retrieveFrom = RetrieveFrom.RIGHT)
	private String title1;
	@LabeledCell(label = "^Cg", retrieveFrom = RetrieveFrom.RIGHT, margedLabel = 1)
	private String title2;
	@PointedCell(position = "(4, 3)")
	private String lastUpdate;

	@VerticalRepeats(targetClass = "some.UserInfo2", label="ꗗ", terminate="Terminate")
	private List<UserInfo2> userInfoList = new ArrayList<UserInfo2>();
	@MappedCell(previousLabel="")
	private Map<String, String> numbersMemberMap = new HashMap<String, String>();

	public String toString() {
		StringBuffer buff = new StringBuffer("User\t");
		buff.append("title1=" + getTitle1() + ", ");
		buff.append("title2=" + getTitle2() + ", ");
		buff.append("lasUpdate=" + getLastUpdate() + "\n");

		for (UserInfo2 userInfo : getUserInfoList()) {
			buff.append(userInfo.toString() + "\n");
		}

		buff.append(" \n ");
		for (String month : numbersMemberMap.keySet()) {
			Object value = numbersMemberMap.get(month);
			buff.append(String.format(" %s=%s", month, value));
		}
		return buff.toString();
	}

	public void setTitle1(String title1) {
		this.title1 = title1;
	}
	public String getTitle1() {
		return title1;
	}

	public void setTitle2(String title2) {
		this.title2 = title2;
	}
	public String getTitle2() {
		return title2;
	}

	public void setLastUpdate(String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}
	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setUserInfoList(List<UserInfo2> userInfoList) {
		this.userInfoList = userInfoList;
	}

	public List<UserInfo2> getUserInfoList() {
		return userInfoList;
	}

	public void setNumbersMemberMap(Map<String, String> numbersMemberMap) {
		this.numbersMemberMap = numbersMemberMap;
	}

	public Map<String, String> getNumbersMemberMap() {
		return numbersMemberMap;
	}


}
